/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.network;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.impl.network.BeRequestMessage;
import org.moddingx.libx.impl.network.BeUpdateMessage;
import org.moddingx.libx.impl.network.ConfigShadowMessage;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.NetworkX;

public final class NetworkImpl
extends NetworkX {
    private static NetworkImpl impl = null;

    public NetworkImpl(ModX mod) {
        super(mod);
        if (impl != null) {
            throw new IllegalStateException("NetworkImpl created twice.");
        }
        impl = this;
    }

    @Nonnull
    public static NetworkImpl getImpl() {
        if (impl == null) {
            throw new IllegalStateException("NetworkImpl not yet created.");
        }
        return impl;
    }

    @Override
    protected NetworkX.Protocol getProtocol() {
        return new NetworkX.Protocol("9", NetworkX.ProtocolSide.VANILLA, NetworkX.ProtocolSide.REQUIRED);
    }

    public boolean canSend() {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().m_91403_() != null && this.channel.isRemotePresent(Minecraft.m_91087_().m_91403_().m_6198_()), () -> () -> true);
    }

    @Override
    protected void registerPackets() {
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new BeUpdateMessage.Serializer(), () -> BeUpdateMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new ConfigShadowMessage.Serializer(), () -> ConfigShadowMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_SERVER, new BeRequestMessage.Serializer(), () -> BeRequestMessage.Handler::new);
    }

    public void updateBE(Level level, BlockPos pos) {
        BeUpdateMessage msg = this.getBeUpdateMessage(level, pos);
        if (msg != null) {
            this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)msg);
        }
    }

    void updateBE(NetworkEvent.Context context, Level level, BlockPos pos) {
        BeUpdateMessage msg = this.getBeUpdateMessage(level, pos);
        if (msg != null) {
            this.channel.reply((Object)msg, context);
        }
    }

    @Nullable
    private BeUpdateMessage getBeUpdateMessage(Level level, BlockPos pos) {
        if (!level.f_46443_ && this.canSend()) {
            BlockEntity be = level.m_7702_(pos);
            if (be == null) {
                return null;
            }
            CompoundTag nbt = be.m_5995_();
            if (nbt == null) {
                return null;
            }
            ResourceLocation id = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_());
            if (id == null) {
                return null;
            }
            return new BeUpdateMessage(pos, id, nbt);
        }
        return null;
    }

    public void requestBE(Level level, BlockPos pos) {
        if (level.f_46443_ && this.canSend()) {
            this.channel.sendToServer((Object)new BeRequestMessage(pos));
        }
    }
}

