/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.noeppi_noeppi.mods.sandbox.SandBox;
import io.github.noeppi_noeppi.mods.sandbox.biome.BiomeLayer;
import io.github.noeppi_noeppi.mods.sandbox.impl.noise.NoiseLayerSelector;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class LayeredBiomeSource
extends BiomeSource {
    public static final Codec<LayeredBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("horizontal_scale").forGetter(biomes -> biomes.horizontalScale), (App)Codec.DOUBLE.fieldOf("vertical_scale").forGetter(biomes -> biomes.verticalScale), (App)RegistryCodecs.m_206279_(SandBox.BIOME_LAYER_REGISTRY, BiomeLayer.DIRECT_CODEC).fieldOf("layers").forGetter(biomes -> biomes.layers)).apply((Applicative)instance, LayeredBiomeSource::new));
    private final double horizontalScale;
    private final double verticalScale;
    private final HolderSet<BiomeLayer> layers;
    private double[] weights;
    private NoiseLayerSelector sel;
    private MultiNoiseBiomeSource[] sources;
    private Climate.ParameterPoint[] ranges;

    public LayeredBiomeSource(double horizontalScale, double verticalScale, HolderSet<BiomeLayer> layers) {
        super(() -> layers.m_203614_().flatMap(layer -> ((BiomeLayer)layer.m_203334_()).biomes().m_186850_().stream()).map(Pair::getSecond).distinct().toList());
        this.horizontalScale = horizontalScale;
        this.verticalScale = verticalScale;
        this.layers = layers;
    }

    public void init(long seed) {
        List<BiomeLayer> layersInOrder = this.layers.m_203614_().map(Holder::m_203334_).toList();
        this.weights = layersInOrder.stream().mapToDouble(BiomeLayer::weight).toArray();
        this.sel = new NoiseLayerSelector(this.horizontalScale, this.verticalScale, this.weights, RandomSource.m_216335_((long)(seed * -6524552231151932243L)));
        this.ranges = (Climate.ParameterPoint[])layersInOrder.stream().map(BiomeLayer::range).toArray(Climate.ParameterPoint[]::new);
        this.sources = (MultiNoiseBiomeSource[])layersInOrder.stream().map(layer -> new MultiNoiseBiomeSource(layer.biomes())).toArray(MultiNoiseBiomeSource[]::new);
    }

    @Nonnull
    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    @Nonnull
    public Holder<Biome> m_203407_(int x, int y, int z, @Nonnull Climate.Sampler sampler) {
        int i;
        if (this.sel == null) {
            throw new IllegalStateException("Random layer selector not initialised.");
        }
        if (this.weights.length == 1) {
            return this.sources[0].m_203407_(x, y, z, sampler);
        }
        Climate.TargetPoint target = sampler.m_183445_(x, y, z);
        int matchAmount = 0;
        int lastMatch = 0;
        boolean[] matches = new boolean[this.weights.length];
        for (i = 0; i < this.weights.length; ++i) {
            if (!LayeredBiomeSource.isInRange(this.ranges[i], target)) continue;
            ++matchAmount;
            matches[i] = true;
            lastMatch = i;
        }
        if (matchAmount == 1) {
            return this.sources[lastMatch].m_204269_(target);
        }
        if (matchAmount == 0) {
            for (i = 0; i < this.weights.length; ++i) {
                matches[i] = true;
            }
        }
        int targetIdx = this.sel.sample(x, y, z, matches);
        return this.sources[targetIdx].m_204269_(target);
    }

    private static boolean isInRange(Climate.ParameterPoint point, Climate.TargetPoint target) {
        if (point.f_186863_().m_186825_(target.f_187003_()) != 0L) {
            return false;
        }
        if (point.f_186864_().m_186825_(target.f_187004_()) != 0L) {
            return false;
        }
        if (point.f_186865_().m_186825_(target.f_187005_()) != 0L) {
            return false;
        }
        if (point.f_186866_().m_186825_(target.f_187006_()) != 0L) {
            return false;
        }
        if (point.f_186867_().m_186825_(target.f_187007_()) != 0L) {
            return false;
        }
        return point.f_186868_().m_186825_(target.f_187008_()) == 0L;
    }

    public void m_207301_(List<String> lines, BlockPos pos, Climate.Sampler sampler) {
        Climate.TargetPoint target = sampler.m_183445_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()));
        float continentalness = Climate.m_186796_((long)target.f_187005_());
        float erosion = Climate.m_186796_((long)target.f_187006_());
        float temperature = Climate.m_186796_((long)target.f_187003_());
        float humidity = Climate.m_186796_((long)target.f_187004_());
        float weirdness = Climate.m_186796_((long)target.f_187008_());
        double peaks = NoiseRouterData.m_224435_((float)weirdness);
        OverworldBiomeBuilder builder = new OverworldBiomeBuilder();
        StringBuilder sb = new StringBuilder("Biome builder");
        sb.append(" PV: ").append(OverworldBiomeBuilder.m_187155_((double)peaks));
        sb.append(" C: ").append(builder.m_187189_((double)continentalness));
        sb.append(" E: ").append(builder.m_187209_((double)erosion));
        sb.append(" T: ").append(builder.m_187220_((double)temperature));
        sb.append(" H: ").append(builder.m_187231_((double)humidity));
        lines.add(sb.toString());
    }
}

