/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen.ext;

import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.SingleWorldGenData;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.WorldGenData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class BiomeData
extends SingleWorldGenData<Biome> {
    public BiomeData(WorldGenData.Properties properties) {
        super(properties, Registry.f_122885_, Biome.f_47429_);
    }

    public BiomeBuilder biome(float temperature, float downfall) {
        return this.biome(null, temperature, downfall);
    }

    public BiomeBuilder biome(ResourceKey<Biome> key, float temperature, float downfall) {
        return new BiomeBuilder(key, temperature, downfall);
    }

    public BiomeSpecialEffects.Builder effects() {
        return new BiomeEffectsBuilder();
    }

    public MobSpawnSettings.Builder spawns() {
        return new BiomeSpawnsBuilder();
    }

    public BiomeGenerationSettings.Builder generation() {
        return new BiomeGenerationBuilder();
    }

    public class BiomeBuilder {
        @Nullable
        private final ResourceKey<Biome> key;
        private final float temperature;
        private final Biome.BiomeBuilder builder;

        private BiomeBuilder(ResourceKey<Biome> key, float temperature, float downfall) {
            this.temperature = temperature;
            this.key = key;
            this.builder = new Biome.BiomeBuilder();
            this.builder.m_47609_(temperature);
            this.builder.m_47611_(downfall);
            this.builder.m_47599_(Biome.TemperatureModifier.NONE);
            this.builder.m_47597_(downfall == 0.0f ? Biome.Precipitation.NONE : Biome.Precipitation.RAIN);
            this.effects(BiomeData.this.effects());
        }

        public BiomeBuilder precipitation(Biome.Precipitation precipitation) {
            this.builder.m_47597_(precipitation);
            return this;
        }

        public BiomeBuilder frozen() {
            this.builder.m_47599_(Biome.TemperatureModifier.FROZEN);
            this.builder.m_47597_(Biome.Precipitation.SNOW);
            return this;
        }

        public BiomeBuilder effects(BiomeSpecialEffects.Builder builder) {
            if (!(builder instanceof BiomeEffectsBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#effects to create a BiomeSpecialEffects.Builder instance.");
            }
            BiomeEffectsBuilder effectBuilder = (BiomeEffectsBuilder)builder;
            effectBuilder.setDefaultSkyColor(this.temperature);
            this.builder.m_47603_(builder.m_48018_());
            return this;
        }

        public BiomeBuilder mobSpawns(MobSpawnSettings.Builder builder) {
            if (!(builder instanceof BiomeSpawnsBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#spawns to create a MobSpawnSettings.Builder instance.");
            }
            this.builder.m_47605_(builder.m_48381_());
            return this;
        }

        public BiomeBuilder generation(BiomeGenerationSettings.Builder builder) {
            if (!(builder instanceof BiomeGenerationBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#generation to create a BiomeGenerationSettings.Builder instance.");
            }
            this.builder.m_47601_(builder.m_47831_());
            return this;
        }

        public Holder<Biome> build() {
            Biome biome = this.builder.m_47592_();
            if (this.key != null) {
                BiomeData.this.registries.register(Registry.f_122885_, this.key.m_135782_(), biome);
            }
            return BiomeData.this.addToList(BiomeData.this.registries.holder(Registry.f_122885_, biome));
        }
    }

    public static class BiomeEffectsBuilder
    extends BiomeSpecialEffects.Builder {
        private BiomeEffectsBuilder() {
            this.m_48019_(12638463);
            this.m_48034_(4159204);
            this.m_48037_(329011);
        }

        private void setDefaultSkyColor(float temperature) {
            if (this.f_48008_.isEmpty()) {
                this.m_48040_(OverworldBiomes.m_194843_((float)temperature));
            }
        }
    }

    public static class BiomeSpawnsBuilder
    extends MobSpawnSettings.Builder {
        private BiomeSpawnsBuilder() {
        }
    }

    public class BiomeGenerationBuilder
    extends BiomeGenerationSettings.Builder {
        private BiomeGenerationBuilder() {
        }

        @Nonnull
        public BiomeGenerationSettings.Builder m_204193_(int step, @Nonnull Holder<PlacedFeature> feature) {
            return super.m_204193_(step, BiomeData.this.registries.holder(Registry.f_194567_, feature));
        }

        @Nonnull
        public BiomeGenerationSettings.Builder m_204198_(@Nonnull GenerationStep.Carving step, @Nonnull Holder<? extends ConfiguredWorldCarver<?>> carver) {
            return super.m_204198_(step, BiomeData.this.registries.holder(Registry.f_122880_, carver));
        }
    }
}

