/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen.ext;

import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.SingleWorldGenData;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.WorldGenData;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionTypeData
extends SingleWorldGenData<DimensionType> {
    public DimensionTypeData(WorldGenData.Properties properties) {
        super(properties, Registry.f_122818_, DimensionType.f_63843_);
    }

    public DimensionTypeBuilder dimension() {
        return new DimensionTypeBuilder();
    }

    public class DimensionTypeBuilder {
        private OptionalLong fixedTime = OptionalLong.empty();
        private boolean hasSkyLight = true;
        private boolean hasCeiling = false;
        private boolean ultraWarm = false;
        private boolean natural = true;
        private double coordinateScale = 1.0;
        private boolean bedWorks = true;
        private boolean respawnAnchorWorks = false;
        private int minY = -64;
        private int height = 384;
        private int logicalHeight = 384;
        private TagKey<Block> infiniburn = BlockTags.f_13058_;
        private ResourceLocation effectsLocation = BuiltinDimensionTypes.f_223542_;
        private float ambientLight = 0.0f;
        private boolean piglinSafe = false;
        private boolean hasRaids = true;
        private IntProvider monsterSpawnLightTest = UniformInt.m_146622_((int)0, (int)7);
        private int monsterSpawnBlockLightLimit = 0;

        private DimensionTypeBuilder() {
        }

        public DimensionTypeBuilder fixedTime(long time) {
            this.fixedTime = OptionalLong.of(time);
            return this;
        }

        public DimensionTypeBuilder sky(boolean skyLight, boolean ceiling) {
            this.hasSkyLight = skyLight;
            this.hasCeiling = ceiling;
            return this;
        }

        public DimensionTypeBuilder ultraWarm() {
            this.ultraWarm = true;
            return this;
        }

        public DimensionTypeBuilder nonNatural() {
            this.natural = false;
            return this;
        }

        public DimensionTypeBuilder coordinateScale(double coordinateScale) {
            this.coordinateScale = coordinateScale;
            return this;
        }

        public DimensionTypeBuilder respawnDevices(boolean bed, boolean respawnAnchor) {
            this.bedWorks = bed;
            this.respawnAnchorWorks = respawnAnchor;
            return this;
        }

        public DimensionTypeBuilder height(int minY, int maxY) {
            return this.height(minY, maxY, maxY - minY);
        }

        public DimensionTypeBuilder height(int minY, int maxY, int logicalHeight) {
            this.minY = minY;
            this.height = maxY - minY;
            this.logicalHeight = Math.min(logicalHeight, this.height);
            return this;
        }

        public DimensionTypeBuilder infiniteBurn(TagKey<Block> key) {
            this.infiniburn = key;
            return this;
        }

        public DimensionTypeBuilder effects(String path) {
            return this.effects(DimensionTypeData.this.mod.resource(path));
        }

        public DimensionTypeBuilder effects(String namespace, String path) {
            return this.effects(new ResourceLocation(namespace, path));
        }

        public DimensionTypeBuilder effects(ResourceLocation id) {
            this.effectsLocation = id;
            return this;
        }

        public DimensionTypeBuilder ambientLight(float ambientLight) {
            this.ambientLight = ambientLight;
            return this;
        }

        public DimensionTypeBuilder piglinSafe() {
            this.piglinSafe = true;
            return this;
        }

        public DimensionTypeBuilder disableRaids() {
            this.hasRaids = false;
            return this;
        }

        public DimensionTypeBuilder monsterSpawnRule(int maxSkyLight, int maxBlockLight) {
            return this.monsterSpawnRule((IntProvider)UniformInt.m_146622_((int)0, (int)maxSkyLight), maxBlockLight);
        }

        public DimensionTypeBuilder monsterSpawnRule(IntProvider skyLight, int maxBlockLight) {
            this.monsterSpawnLightTest = skyLight;
            this.monsterSpawnBlockLightLimit = maxBlockLight;
            return this;
        }

        public Holder<DimensionType> build() {
            DimensionType type = new DimensionType(this.fixedTime, this.hasSkyLight, this.hasCeiling, this.ultraWarm, this.natural, this.coordinateScale, this.bedWorks, this.respawnAnchorWorks, this.minY, this.height, this.logicalHeight, this.infiniburn, this.effectsLocation, this.ambientLight, new DimensionType.MonsterSettings(this.piglinSafe, this.hasRaids, this.monsterSpawnLightTest, this.monsterSpawnBlockLightLimit));
            return DimensionTypeData.this.addToList(DimensionTypeData.this.registries.holder(Registry.f_122818_, type));
        }
    }
}

