/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.noeppi_noeppi.mods.sandbox.SandBox;
import io.github.noeppi_noeppi.mods.sandbox.impl.DelegateHolder;
import io.github.noeppi_noeppi.mods.sandbox.surface.BiomeSurface;
import io.github.noeppi_noeppi.mods.sandbox.surface.SurfaceRuleSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class ExtendedNoiseGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<ExtendedNoiseGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(gen -> gen.biomeRegistry), (App)RegistryOps.m_206832_(SandBox.BIOME_SURFACE_REGISTRY).forGetter(gen -> gen.surfaceRegistry), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(gen -> gen.f_207955_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(gen -> gen.noiseRegistry), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.actualSettings), (App)SurfaceRuleSet.CODEC.optionalFieldOf("surface_override").forGetter(gen -> gen.surfaceOverride)).apply((Applicative)instance, ExtendedNoiseGenerator::new));
    private final Registry<Biome> biomeRegistry;
    private final Registry<BiomeSurface> surfaceRegistry;
    private final Registry<NormalNoise.NoiseParameters> noiseRegistry;
    private final Optional<Holder<SurfaceRuleSet>> surfaceOverride;
    private final Holder<NoiseGeneratorSettings> actualSettings;
    private final DelegateHolder<NoiseGeneratorSettings> fakeSettings;

    public ExtendedNoiseGenerator(Registry<Biome> biomeRegistry, Registry<BiomeSurface> surfaceRegistry, Registry<StructureSet> structureRegistry, Registry<NormalNoise.NoiseParameters> noiseRegistry, BiomeSource biomes, Holder<NoiseGeneratorSettings> settings, Optional<Holder<SurfaceRuleSet>> surfaceOverride) {
        this(biomeRegistry, surfaceRegistry, structureRegistry, noiseRegistry, biomes, settings, new DelegateHolder<NoiseGeneratorSettings>(settings, true), surfaceOverride);
    }

    private ExtendedNoiseGenerator(Registry<Biome> biomeRegistry, Registry<BiomeSurface> surfaceRegistry, Registry<StructureSet> structureRegistry, Registry<NormalNoise.NoiseParameters> noiseRegistry, BiomeSource biomes, Holder<NoiseGeneratorSettings> settings, DelegateHolder<NoiseGeneratorSettings> delegate, Optional<Holder<SurfaceRuleSet>> surfaceOverride) {
        super(structureRegistry, noiseRegistry, biomes, delegate);
        this.biomeRegistry = biomeRegistry;
        this.surfaceRegistry = surfaceRegistry;
        this.noiseRegistry = noiseRegistry;
        this.surfaceOverride = surfaceOverride;
        this.actualSettings = settings;
        this.fakeSettings = delegate;
    }

    public void init() {
        if (this.surfaceOverride.isPresent()) {
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)this.actualSettings.get();
            SurfaceRuleSet set = (SurfaceRuleSet)this.surfaceOverride.get().get();
            Set biomes = this.f_62137_.m_207840_();
            SurfaceRules.RuleSource surfaceRule = set.build(this.biomeRegistry, this.surfaceRegistry, biomes, (NoiseGeneratorSettings)this.f_64318_.get());
            this.fakeSettings.set((Holder<NoiseGeneratorSettings>)Holder.m_205709_((Object)ExtendedNoiseGenerator.withSurface(settings, surfaceRule)));
        }
    }

    @Nonnull
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    @Nonnull
    public Holder<NoiseGeneratorSettings> m_224341_() {
        return this.actualSettings;
    }

    public boolean m_224221_(@Nonnull ResourceKey<NoiseGeneratorSettings> settings) {
        return this.actualSettings.m_203565_(settings);
    }

    private static NoiseGeneratorSettings withSurface(NoiseGeneratorSettings settings, SurfaceRules.RuleSource surfaceRule) {
        return new NoiseGeneratorSettings(settings.f_64439_(), settings.f_64440_(), settings.f_64441_(), settings.f_209353_(), surfaceRule, settings.f_224370_(), settings.f_64444_(), settings.f_64445_(), settings.f_158533_(), settings.m_209369_(), settings.f_209354_());
    }
}

