/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network;

import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.core.EnhancedCelestialsContext;
import corgitaco.enhancedcelestials.lunarevent.LunarEventInstance;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import corgitaco.enhancedcelestials.network.S2CPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public class LunarForecastChangedPacket
implements S2CPacket {
    private final LunarForecast.Data lunarForecast;
    private final boolean isNight;

    public LunarForecastChangedPacket(LunarForecast forecast, boolean isNight) {
        this(forecast.data(), isNight);
    }

    public LunarForecastChangedPacket(LunarForecast.Data lunarForecast, boolean isNight) {
        this.lunarForecast = lunarForecast;
        this.isNight = isNight;
    }

    public static LunarForecastChangedPacket readFromPacket(FriendlyByteBuf buf) {
        try {
            return new LunarForecastChangedPacket((LunarForecast.Data)buf.m_130057_(LunarForecast.Data.CODEC), buf.readBoolean());
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        try {
            buf.m_130059_(LunarForecast.Data.CODEC, (Object)this.lunarForecast);
            buf.writeBoolean(this.isNight);
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    @Override
    public void handle(Level level) {
        EnhancedCelestialsContext enhancedCelestialsContext;
        if (level != null && (enhancedCelestialsContext = ((EnhancedCelestialsWorldData)level).getLunarContext()) != null) {
            LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
            lunarForecast.getForecast().clear();
            lunarForecast.getForecast().addAll(this.lunarForecast.forecast());
            lunarForecast.getPastEvents().clear();
            lunarForecast.getPastEvents().addAll(this.lunarForecast.pastEvents());
            lunarForecast.setLastCheckedGameTime(this.lunarForecast.lastCheckedGameTime());
            if (!lunarForecast.getForecast().isEmpty()) {
                LunarEventInstance lunarEventInstance = lunarForecast.getForecast().get(0);
                LunarDimensionSettings lunarDimensionSettings = (LunarDimensionSettings)lunarForecast.getDimensionSettingsHolder().m_203334_();
                long currentDay = level.m_46468_() / lunarDimensionSettings.dayLength();
                if (lunarEventInstance.active(currentDay) && this.isNight) {
                    lunarForecast.setCurrentEvent(lunarEventInstance.getLunarEventKey());
                } else {
                    lunarForecast.setCurrentEvent(lunarDimensionSettings.defaultEvent());
                }
            }
        }
    }
}

