/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.serialization.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.mixin.access.ColorAccess;
import corgitaco.corgilib.mixin.access.StyleAccess;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class CodecUtil {
    public static final Codec<Block> BLOCK_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122824_);
    public static final Codec<MobEffect> MOB_EFFECT = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122823_);
    public static final Codec<EntityType<?>> ENTITY_TYPE = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122826_);
    public static final Codec<EntityType<?>> ENTITY_TYPE_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122826_);
    public static final Codec<Attribute> ATTRIBUTE_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122866_);
    public static final Codec<Item> ITEM_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122827_);
    public static final Codec<Enchantment> ENCHANTMENT_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122825_);
    public static final Codec<MobEffect> EFFECT_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(Registry.f_122823_);
    public static final Codec<ResourceKey<Biome>> BIOME_CODEC = ResourceLocation.f_135803_.comapFlatMap(resourceLocation -> DataResult.success((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)resourceLocation)), ResourceKey::m_135782_);
    public static final Codec<EquipmentSlot> EQUIPMENT_SLOT_CODEC = Codec.STRING.comapFlatMap(s -> {
        EquipmentSlot equipmentSlotType = EquipmentSlot.m_20747_((String)s.toLowerCase());
        if (equipmentSlotType == null) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid equipmentSlotType. Valid equipmentSlotTypes: %s", s, Arrays.toString(Arrays.stream(EquipmentSlot.values()).map(EquipmentSlot::m_20751_).toArray())));
        }
        return DataResult.success((Object)equipmentSlotType);
    }, EquipmentSlot::m_20751_);
    public static final Codec<Difficulty> DIFFICULTY_CODEC = Codec.STRING.comapFlatMap(s -> {
        Difficulty difficulty = Difficulty.m_19031_((String)s.toLowerCase());
        if (difficulty == null) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid difficulty. Valid difficulties: %s", s, Arrays.toString(Arrays.stream(Difficulty.values()).map(Difficulty::m_19036_).toArray())));
        }
        return DataResult.success((Object)difficulty);
    }, Difficulty::m_19036_);
    public static final Codec<ClickEvent.Action> CLICK_EVENT_ACTION_CODEC = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)ClickEvent.Action.valueOf((String)s));
        }
        catch (Exception e) {
            return DataResult.error((String)e.getMessage());
        }
    }, Enum::name);
    public static final Codec<ClickEvent> CLICK_EVENT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CLICK_EVENT_ACTION_CODEC.fieldOf("action").forGetter(ClickEvent::m_130622_), (App)Codec.STRING.fieldOf("value").forGetter(ClickEvent::m_130623_)).apply((Applicative)builder, ClickEvent::new));
    public static Codec<Integer> COLOR_FROM_HEX = Codec.STRING.comapFlatMap(CodecUtil.validateColorHex(), Integer::toHexString);
    public static final Codec<Style> STYLE_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)COLOR_FROM_HEX.optionalFieldOf("color", (Object)ChatFormatting.WHITE.m_126665_()).forGetter(style -> style.m_131135_() != null ? Integer.valueOf(style.m_131135_().m_131265_()) : ChatFormatting.WHITE.m_126665_()), (App)Codec.BOOL.optionalFieldOf("bold", (Object)false).forGetter(Style::m_131154_), (App)Codec.BOOL.optionalFieldOf("italic", (Object)false).forGetter(Style::m_131161_), (App)Codec.BOOL.optionalFieldOf("underlined", (Object)false).forGetter(Style::m_131171_), (App)Codec.BOOL.optionalFieldOf("strikethrough", (Object)false).forGetter(Style::m_131168_), (App)Codec.BOOL.optionalFieldOf("obfuscated", (Object)false).forGetter(Style::m_131176_), (App)CLICK_EVENT_CODEC.optionalFieldOf("click_event").forGetter(style -> style.m_131182_() != null ? Optional.of(style.m_131182_()) : Optional.empty())).apply((Applicative)builder, (color, bold, italic, underlined, strikethrough, obfuscated, clickEvent) -> StyleAccess.create(ColorAccess.create(color), bold, italic, underlined, strikethrough, obfuscated, clickEvent.orElse(null), null, null, null)));
    public static final Codec<Integer> INTEGER_KEY_CODEC = Codec.STRING.comapFlatMap(s -> DataResult.success((Object)Integer.valueOf(s)), Object::toString);

    public static Function<String, DataResult<Integer>> validateColorHex() {
        return input -> {
            if (input.isEmpty()) {
                return DataResult.success((Object)ChatFormatting.WHITE.m_126665_());
            }
            try {
                return DataResult.success((Object)((int)Long.parseLong(input.replace("#", "").replace("0x", ""), 16)));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return DataResult.error((String)e.getMessage());
            }
        };
    }

    public static Codec<Integer> intKeyRangeCodec(int min, int max) {
        Function check = Codec.checkRange((Number)min, (Number)max);
        return INTEGER_KEY_CODEC.flatXmap(check, check);
    }

    public static <T> Codec<T> createLoggedExceptionRegistryCodec(Registry<T> registry) {
        return ResourceLocation.f_135803_.comapFlatMap(location -> {
            Optional result = registry.m_6612_(location);
            if (result.isEmpty()) {
                StringBuilder registryElements = new StringBuilder();
                for (int i = 0; i < registry.m_6579_().size(); ++i) {
                    Object object = registry.m_7942_(i);
                    registryElements.append(i).append(". \"").append(registry.m_7981_(object).toString()).append("\"\n");
                }
                return DataResult.error((String)String.format("\"%s\" is not a valid id in registry: %s.\nCurrent Registry Values:\n\n%s\n", location.toString(), registry.toString(), registryElements.toString()));
            }
            return DataResult.success(result.get());
        }, arg_0 -> registry.m_7981_(arg_0));
    }

    public static <T> Codec<WrapForSerialization<T>> wrapCodecForCollectionSerializing(Codec<T> codec) {
        return RecordCodecBuilder.create(builder -> builder.group((App)codec.fieldOf("value").forGetter(tWrapForSerialization -> tWrapForSerialization.value)).apply((Applicative)builder, WrapForSerialization::new));
    }

    public static <T> WrapForSerialization<T> wrap(T toWrap) {
        return new WrapForSerialization<T>(toWrap);
    }

    public record WrapForSerialization<T>(T value) {
    }

    public record LazyCodec<TYPE>(Supplier<Codec<TYPE>> delegate) implements Codec<TYPE>
    {
        public <T> DataResult<T> encode(TYPE input, DynamicOps<T> ops, T prefix) {
            return this.delegate().get().encode(input, ops, prefix);
        }

        public <T> DataResult<Pair<TYPE, T>> decode(DynamicOps<T> ops, T input) {
            return this.delegate().get().decode(ops, input);
        }
    }
}

