/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.world.level.feature.gen;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.mixin.access.LeavesBlockAccess;
import corgitaco.corgilib.mixin.access.StructureTemplateAccess;
import corgitaco.corgilib.world.level.feature.gen.configurations.TreeFromStructureNBTConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class TreeFromStructureNBTFeature
extends Feature<TreeFromStructureNBTConfig> {
    private static final boolean DEBUG = false;

    public TreeFromStructureNBTFeature(Codec<TreeFromStructureNBTConfig> $$0) {
        super($$0);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeFromStructureNBTConfig> featurePlaceContext) {
        TreeFromStructureNBTConfig config = (TreeFromStructureNBTConfig)featurePlaceContext.m_159778_();
        BlockStateProvider logProvider = config.logProvider();
        BlockStateProvider leavesProvider = config.leavesProvider();
        WorldGenLevel level = featurePlaceContext.m_159774_();
        StructureTemplateManager templateManager = level.m_6018_().m_215082_();
        ResourceLocation baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.m_230407_(baseLocation);
        ResourceLocation canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.m_230407_(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(canopyLocation);
        }
        StructureTemplate baseTemplate = (StructureTemplate)baseTemplateOptional.get();
        StructureTemplate canopyTemplate = (StructureTemplate)canopyTemplateOptional.get();
        List<StructureTemplate.Palette> basePalettes = ((StructureTemplateAccess)baseTemplate).byg_getPalettes();
        List<StructureTemplate.Palette> canopyPalettes = ((StructureTemplateAccess)canopyTemplate).byg_getPalettes();
        BlockPos origin = featurePlaceContext.m_159777_();
        RandomSource random = featurePlaceContext.m_225041_();
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(Rotation.m_221990_((RandomSource)random));
        StructureTemplate.Palette trunkBasePalette = placeSettings.m_74387_(basePalettes, origin);
        StructureTemplate.Palette randomCanopyPalette = placeSettings.m_74387_(canopyPalettes, origin);
        List center = trunkBasePalette.m_74653_(Blocks.f_50041_);
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one central position.");
        }
        BlockPos centerOffset = ((StructureTemplate.StructureBlockInfo)center.get((int)0)).f_74675_;
        centerOffset = new BlockPos(-centerOffset.m_123341_(), 0, -centerOffset.m_123343_());
        List logs = trunkBasePalette.m_74653_(config.logTarget());
        List logBuilders = trunkBasePalette.m_74653_(Blocks.f_50108_);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        HashSet<BlockPos> leavePositions = new HashSet<BlockPos>();
        HashSet<BlockPos> trunkPositions = new HashSet<BlockPos>();
        int trunkLength = config.height().m_214085_(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            if (TreeFromStructureNBTFeature.isOnGround(config.maxLogDepth(), level, pos)) continue;
            return false;
        }
        TreeFromStructureNBTFeature.fillLogsUnder(random, logProvider, level, origin, placeSettings, centerOffset, logBuilders, maxTrunkBuildingDepth);
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, origin, random, placeSettings, centerOffset, logs, trunkPositions);
        TreeFromStructureNBTFeature.placeCanopy(config, logProvider, leavesProvider, level, origin, random, placeSettings, randomCanopyPalette, center, leavePositions, trunkPositions, trunkLength);
        TreeFromStructureNBTFeature.placeTreeDecorations(config.treeDecorators(), level, random, leavePositions, trunkPositions);
        return true;
    }

    private static void placeCanopy(TreeFromStructureNBTConfig config, BlockStateProvider logProvider, BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, StructureTemplate.Palette randomCanopyPalette, List<StructureTemplate.StructureBlockInfo> center, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions, int trunkLength) {
        List leaves = randomCanopyPalette.m_74653_(config.leavesTarget());
        List canopyLogs = randomCanopyPalette.m_74653_(config.logTarget());
        List canopyAnchor = randomCanopyPalette.m_74653_(Blocks.f_50041_);
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one central position.");
        }
        if (center.isEmpty()) {
            throw new IllegalArgumentException("Canopy is missing anchor block (yellow wool).");
        }
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)canopyAnchor.get(0);
        BlockPos canopyCenterOffset = structureBlockInfo.f_74675_;
        canopyCenterOffset = new BlockPos(-canopyCenterOffset.m_123341_(), trunkLength, -canopyCenterOffset.m_123343_());
        ArrayList<StructureTemplate.StructureBlockInfo> trunkFillers = new ArrayList<StructureTemplate.StructureBlockInfo>(randomCanopyPalette.m_74653_(Blocks.f_50108_));
        trunkFillers.addAll(randomCanopyPalette.m_74653_(Blocks.f_50098_));
        TreeFromStructureNBTFeature.fillLogsUnder(random, logProvider, level, origin, placeSettings, canopyCenterOffset, trunkFillers, level.m_141928_());
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, origin, random, placeSettings, canopyCenterOffset, canopyLogs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, random, placeSettings, leaves, leavePositions, canopyCenterOffset);
    }

    public static void placeLogsWithRotation(BlockStateProvider logProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, Set<BlockPos> trunkPositions) {
        for (StructureTemplate.StructureBlockInfo trunk : logs) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            level.m_7731_(pos, TreeFromStructureNBTFeature.getTransformedState(logProvider.m_213972_(random, pos), trunk.f_74676_, placeSettings.m_74404_()), 2);
            trunkPositions.add(pos);
        }
    }

    public static void placeTreeDecorations(Iterable<TreeDecorator> treeDecorators, WorldGenLevel level, RandomSource random, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions) {
        for (TreeDecorator treeDecorator : treeDecorators) {
            treeDecorator.m_214187_(new TreeDecorator.Context((LevelSimulatedReader)level, (pos, state) -> level.m_7731_(pos, state, 2), random, trunkPositions, leavePositions, new HashSet()));
        }
    }

    public static void placeLeavesWithCalculatedDistanceAndRotation(BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, List<StructureTemplate.StructureBlockInfo> leaves, Set<BlockPos> leavePositions, BlockPos canopyCenterOffset) {
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leaves.size());
        for (StructureTemplate.StructureBlockInfo leaf : leaves) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
            BlockState state = leavesProvider.m_213972_(random, pos);
            if (state.m_61138_((Property)LeavesBlock.f_54418_) && leaf.f_74676_.m_61138_((Property)LeavesBlock.f_54418_)) {
                state = (BlockState)state.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)((Integer)leaf.f_74676_.m_61143_((Property)LeavesBlock.f_54418_)));
            }
            if (level.m_8055_(pos).m_60815_()) continue;
            level.m_7731_(pos, state, 2);
            BlockState finalState = state;
            Runnable postProcess = () -> {
                BlockState blockState = LeavesBlockAccess.byg_invokeUpdateDistance(finalState, (LevelAccessor)level, pos);
                if ((Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_) < 7) {
                    leavePositions.add(pos);
                    level.m_7731_(pos, blockState, 2);
                    level.m_186460_(pos, blockState.m_60734_(), 0);
                } else {
                    level.m_7471_(pos, false);
                }
            };
            leavesPostApply.add(postProcess);
        }
        leavesPostApply.forEach(Runnable::run);
    }

    public static void fillLogsUnder(RandomSource randomSource, BlockStateProvider logProvider, WorldGenLevel level, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth) {
        block0: for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
                if (blockState.m_60815_()) {
                    Block block = blockState.m_60734_();
                    level.m_186460_((BlockPos)mutableBlockPos, block, 0);
                    continue block0;
                }
                level.m_7731_((BlockPos)mutableBlockPos, logProvider.m_213972_(randomSource, (BlockPos)mutableBlockPos), 2);
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
        }
    }

    @NotNull
    private static BlockState getTransformedState(BlockState state, BlockState canopyLogState, Rotation rotation) {
        Direction.Axis axis;
        for (Property property : state.m_61147_()) {
            if (!canopyLogState.m_61138_(property)) continue;
            Comparable value = canopyLogState.m_61143_(property);
            state = (BlockState)state.m_61124_(property, value);
        }
        if (state.m_61138_((Property)RotatedPillarBlock.f_55923_) && (axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)).m_122479_() && (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90)) {
            if (axis == Direction.Axis.X) {
                state = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
            } else if (axis == Direction.Axis.Z) {
                state = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
            }
        }
        return state;
    }

    private static boolean isOnGround(int maxLogDepth, WorldGenLevel level, BlockPos pos) {
        int oceanFloorHeight = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
        if (pos.m_123342_() > oceanFloorHeight) {
            return pos.m_123342_() - oceanFloorHeight < maxLogDepth;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.m_122173_(Direction.DOWN);
            BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
            if (blockState.m_60767_().m_76336_()) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getModifiedPos(StructurePlaceSettings settings, StructureTemplate.StructureBlockInfo placing, BlockPos partCenter, BlockPos featureOrigin) {
        return StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)placing.f_74675_).m_121955_((Vec3i)featureOrigin).m_121955_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)partCenter));
    }

    public static IllegalArgumentException noTreePartPresent(ResourceLocation location) {
        throw new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }
}

