/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.mediumcore.event;

import com.github.alexmodguy.mediumcore.GameRuleRegistry;
import com.github.alexmodguy.mediumcore.Mediumcore;
import com.github.alexmodguy.mediumcore.MediumcoreTags;
import com.github.alexmodguy.mediumcore.misc.DedicatedServerPropertiesAccessor;
import com.github.alexmodguy.mediumcore.packet.SyncMediumcoreGameRuleMessage;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEvents {
    private static final String HEALTH_MODIFIER_TAG = "MediumcoreHealthModifier";
    private static final UUID INITIAL_HEALTH_MODIFIER_UUID = Mth.m_216261_((RandomSource)RandomSource.m_216335_((long)2929292911123L));
    private static final UUID HEALTH_MODIFIER_UUID = Mth.m_216261_((RandomSource)RandomSource.m_216335_((long)111222333441249L));

    @SubscribeEvent
    public void onEntityJoinLevel(ServerStartedEvent event) {
        DedicatedServer dedicatedServer;
        boolean propertiesSayMediumcore;
        MinecraftServer minecraftServer;
        if (event.getServer().m_6982_() && (minecraftServer = event.getServer()) instanceof DedicatedServer && (propertiesSayMediumcore = ((DedicatedServerPropertiesAccessor)(dedicatedServer = (DedicatedServer)minecraftServer).m_7913_()).isServerMediumcore())) {
            Mediumcore.LOGGER.info("set server game rule for mediumcore because it is set to true in server.properties");
            GameRuleRegistry.setMediumcoreMode(event.getServer().m_129900_(), propertiesSayMediumcore, event.getServer());
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            boolean mediumcore;
            Player player = (Player)entity;
            if (!event.getLevel().f_46443_ && (mediumcore = GameRuleRegistry.isMediumCoreMode(event.getLevel().m_46469_())) && player instanceof ServerPlayer) {
                Mediumcore.sendNonLocal(new SyncMediumcoreGameRuleMessage(mediumcore), (ServerPlayer)player);
                CompoundTag tag = event.getEntity().getPersistentData().m_128469_("PlayerPersisted");
                double healthModifiedBy = tag.m_128459_(HEALTH_MODIFIER_TAG);
                this.updateHealth(player, healthModifiedBy);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && GameRuleRegistry.isMediumCoreMode(player.m_9236_().m_46469_())) {
                CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
                double clampedHealth = Mth.m_14008_((double)((double)player.m_21233_() - (Double)Mediumcore.CONFIG.healthDecreasePerDeath.get()), (double)((Double)Mediumcore.CONFIG.minimumPlayerHealth.get()), (double)((Double)Mediumcore.CONFIG.maxPlayerHealth.get()));
                double healthModifiedBy = tag.m_128459_(HEALTH_MODIFIER_TAG) + (clampedHealth - (double)player.m_21233_());
                tag.m_128347_(HEALTH_MODIFIER_TAG, healthModifiedBy);
                player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isEndConquered() && !event.getEntity().m_9236_().f_46443_ && GameRuleRegistry.isMediumCoreMode(event.getEntity().m_9236_().m_46469_())) {
            CompoundTag tag = event.getEntity().getPersistentData().m_128469_("PlayerPersisted");
            double healthModifiedBy = tag.m_128459_(HEALTH_MODIFIER_TAG);
            this.updateHealth(event.getEntity(), healthModifiedBy);
        }
    }

    @SubscribeEvent
    public void onLivingFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && event.getItem().m_204117_(MediumcoreTags.RESTORES_MAX_HEALTH) && GameRuleRegistry.isMediumCoreMode(event.getEntity().m_9236_().m_46469_())) {
                CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
                double clampedHealth = Mth.m_14008_((double)((double)player.m_21233_() + (Double)Mediumcore.CONFIG.healthIncreasePerHeal.get()), (double)((Double)Mediumcore.CONFIG.minimumPlayerHealth.get()), (double)((Double)Mediumcore.CONFIG.maxPlayerHealth.get()));
                double healthModifiedBy = tag.m_128459_(HEALTH_MODIFIER_TAG) + (clampedHealth - (double)player.m_21233_());
                tag.m_128347_(HEALTH_MODIFIER_TAG, healthModifiedBy);
                player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
                this.updateHealth(player, healthModifiedBy);
            }
        }
    }

    private void updateHealth(Player player, double healthModifiedBy) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22276_);
        attribute.m_22127_(INITIAL_HEALTH_MODIFIER_UUID);
        attribute.m_22125_(new AttributeModifier(INITIAL_HEALTH_MODIFIER_UUID, "MediumcoreInitialHealthMod", (Double)Mediumcore.CONFIG.startingPlayerHealth.get() - 20.0, AttributeModifier.Operation.ADDITION));
        attribute.m_22127_(HEALTH_MODIFIER_UUID);
        attribute.m_22125_(new AttributeModifier(HEALTH_MODIFIER_UUID, "MediumcoreHealthMod", healthModifiedBy, AttributeModifier.Operation.ADDITION));
        player.m_21153_(Mth.m_14036_((float)player.m_21223_(), (float)0.0f, (float)player.m_21233_()));
    }
}

