/*
 * Decompiled with CFR 0.152.
 */
package com.medelcitizens.client.gui.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CustomGuiSlider
extends GuiButton {
    public float sliderPosition = 1.0f;
    public boolean isMouseDown = false;
    public final String name;
    public final float min;
    public final float max;
    public final GuiPageButtonList.GuiResponder responder;
    public GuiSlider.FormatHelper formatHelper;

    public CustomGuiSlider(GuiPageButtonList.GuiResponder guiResponder, int idIn, int x, int y, int widthIn, int heightIn, String nameIn, float minIn, float maxIn, float defaultValue, GuiSlider.FormatHelper formatter) {
        super(idIn, x, y, widthIn, heightIn, "");
        this.name = nameIn;
        this.min = minIn;
        this.max = maxIn;
        this.sliderPosition = (defaultValue - minIn) / (maxIn - minIn);
        this.formatHelper = formatter;
        this.responder = guiResponder;
        this.field_146126_j = this.getDisplayString();
    }

    public float getSliderValue() {
        return this.min + (this.max - this.min) * this.sliderPosition;
    }

    public void setSliderValue(float value, boolean notifyResponder) {
        this.sliderPosition = (value - this.min) / (this.max - this.min);
        this.field_146126_j = this.getDisplayString();
        if (notifyResponder) {
            this.responder.func_175320_a(this.field_146127_k, this.getSliderValue());
        }
    }

    public float getSliderPosition() {
        return this.sliderPosition;
    }

    public String getDisplayString() {
        return this.formatHelper == null ? I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + ": " + this.getSliderValue() : this.formatHelper.func_175318_a(this.field_146127_k, I18n.func_135052_a((String)this.name, (Object[])new Object[0]), this.getSliderValue());
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    public void updateScroll(int mouseX) {
        if (this.isMouseDown) {
            this.sliderPosition = (float)(mouseX - this.field_146128_h) / (float)this.field_146120_f;
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.field_146126_j = this.getDisplayString();
            this.responder.func_175320_a(this.field_146127_k, this.getSliderValue());
        }
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderPosition * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderPosition * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public void setSliderPosition(float position) {
        this.sliderPosition = position;
        this.field_146126_j = this.getDisplayString();
        this.responder.func_175320_a(this.field_146127_k, this.getSliderValue());
    }

    public void func_146118_a(int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public static interface FormatHelper {
        public String getText(int var1, String var2, float var3);
    }
}

