/*
 * Decompiled with CFR 0.152.
 */
package com.medelcitizens.common.tileentity.render;

import com.google.common.collect.Maps;
import com.medelcitizens.ModelCitizensRemakeMod;
import com.medelcitizens.common.network.PacketUpdateNBTTagTileEntity;
import com.medelcitizens.common.textures.CustomBindTextures;
import com.medelcitizens.common.tileentity.PuppetTileEntity;
import com.modularwarfare.client.ClientRenderHooks;
import com.modularwarfare.client.fpp.basic.models.objects.CustomItemRenderType;
import com.modularwarfare.client.model.ModelCustomArmor;
import com.modularwarfare.common.armor.ArmorType;
import com.modularwarfare.common.armor.ItemMWArmor;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponAnimationType;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelSkeleton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.opengl.GL11;

public class RenderTilePuppet
extends TileEntitySpecialRenderer<PuppetTileEntity> {
    public ModelBiped modelPlayer = new ModelBiped(0.0f);
    public ModelSkeleton modelSkeleton = new ModelSkeleton();
    public ModelBiped modelArmor = new ModelBiped(0.5f);
    public ModelBiped modelArmorChestplate = new ModelBiped(1.0f);
    private ModelBiped getModel;
    public float headScaleX;
    public float headScaleY;
    public float headScaleZ;
    public float headRotateX;
    public float headRotateY;
    public float headRotateZ;
    public float bodyScaleX;
    public float bodyScaleY;
    public float bodyScaleZ;
    public float bodyRotateX;
    public float bodyRotateY;
    public float bodyRotateZ;
    public float leftArmScaleX;
    public float leftArmScaleY;
    public float leftArmScaleZ;
    public float leftArmRotateX;
    public float leftArmRotateY;
    public float leftArmRotateZ;
    public float rightArmScaleX;
    public float rightArmScaleY;
    public float rightArmScaleZ;
    public float rightArmRotateX;
    public float rightArmRotateY;
    public float rightArmRotateZ;
    public float rightLegScaleX;
    public float rightLegScaleY;
    public float rightLegScaleZ;
    public float rightLegRotateX;
    public float rightLegRotateY;
    public float rightLegRotateZ;
    public float leftLegScaleX;
    public float leftLegScaleY;
    public float leftLegScaleZ;
    public float leftLegRotateX;
    public float leftLegRotateY;
    public float leftLegRotateZ;
    public float itemScaleX;
    public float itemScaleY;
    public float itemScaleZ;
    public float itemPosX;
    public float itemPosY;
    public float itemPosZ;
    public float itemRotateX;
    public float itemRotateY;
    public float itemRotateZ;
    public float puppetScaleX;
    public float puppetScaleY;
    public float puppetScaleZ;
    public float puppetPosX;
    public float puppetPosY;
    public float puppetPosZ;
    public float puppetRotateX;
    public float puppetRotateY;
    public float puppetRotateZ;
    public static boolean isBipedArm;
    public static boolean isSkeletonModel;
    public static boolean isRenderModel;
    public boolean showHead = false;
    public boolean showBody = false;
    public boolean showLeftArm = false;
    public boolean showRightArm = false;
    public boolean showLeftLeg = false;
    public boolean showRightLeg = false;
    public static Field textureListField;
    public static Map textureList;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP;

    public RenderTilePuppet() {
        try {
            textureListField = TextureManager.class.getDeclaredField("mapTextureObjects");
        }
        catch (Exception var5) {
            try {
                textureListField = TextureManager.class.getDeclaredField("field_110585_a");
            }
            catch (Exception var4) {
                System.out.println("ERROR: Couldn't get TextureManager.mapTextureObjects field");
            }
        }
        if (textureListField != null) {
            textureListField.setAccessible(true);
            try {
                textureList = (Map)textureListField.get(Minecraft.func_71410_x().func_110434_K());
            }
            catch (Exception var3) {
                System.out.println("ERROR: Couldn't get TextureManager.mapTextureObjects object");
            }
        }
    }

    public void renderModelForType(ItemStack stack, int n, EntityEquipmentSlot slot) {
        if (Loader.isModLoaded((String)"modularwarfare")) {
            if (!stack.func_190926_b()) {
                if (stack.func_77973_b() instanceof ItemMWArmor) {
                    ArmorType armorType = ((ItemMWArmor)stack.func_77973_b()).type;
                    ModelCustomArmor armorModel = (ModelCustomArmor)armorType.bipedModel;
                    if (slot != EntityEquipmentSlot.MAINHAND) {
                        if (slot != EntityEquipmentSlot.OFFHAND) {
                            armorModel.showChest(slot == EntityEquipmentSlot.CHEST);
                            armorModel.showFeet(slot == EntityEquipmentSlot.FEET);
                            armorModel.showHead(slot == EntityEquipmentSlot.HEAD);
                            armorModel.showLegs(slot == EntityEquipmentSlot.LEGS);
                        }
                    }
                    armorModel.func_178686_a((ModelBase)this.getModel);
                    GL11.glPushMatrix();
                    if (slot == EntityEquipmentSlot.HEAD) {
                        if (this.showHead) {
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            this.getModel.field_78116_c.func_78794_c(0.0625f);
                            armorModel.render("headModel", this.getModel.field_78116_c, 0.0625f, 1.0f);
                            GlStateManager.func_179121_F();
                        }
                    } else if (slot == EntityEquipmentSlot.CHEST) {
                        if (this.showBody) {
                            GlStateManager.func_179094_E();
                            this.getModel.field_78115_e.func_78794_c(0.0625f);
                            armorModel.render("bodyModel", this.getModel.field_78115_e, 0.0625f, 1.0f);
                            GlStateManager.func_179121_F();
                        }
                        if (this.showLeftArm) {
                            GlStateManager.func_179094_E();
                            this.getModel.field_178724_i.func_78794_c(0.0625f);
                            GlStateManager.func_179109_b((float)-0.31f, (float)-0.128f, (float)0.0f);
                            armorModel.render("leftArmModel", this.getModel.field_178724_i, 0.0625f, 1.0f);
                            GlStateManager.func_179121_F();
                        }
                        if (this.showRightArm) {
                            GlStateManager.func_179094_E();
                            this.getModel.field_178723_h.func_78794_c(0.0625f);
                            GlStateManager.func_179109_b((float)0.31f, (float)-0.128f, (float)0.0f);
                            armorModel.render("rightArmModel", this.getModel.field_178723_h, 0.0625f, 1.0f);
                            GlStateManager.func_179121_F();
                        }
                    } else if (slot == EntityEquipmentSlot.LEGS) {
                        if (this.showLeftLeg) {
                            GlStateManager.func_179094_E();
                            this.getModel.field_178722_k.func_78794_c(0.0625f);
                            GlStateManager.func_179109_b((float)-0.117f, (float)-0.74f, (float)0.0f);
                            armorModel.render("leftLegModel", this.getModel.field_178722_k, 0.0625f, 1.0f);
                            GlStateManager.func_179121_F();
                        }
                        if (this.showRightLeg) {
                            GlStateManager.func_179094_E();
                            this.getModel.field_178721_j.func_78794_c(0.0625f);
                            GlStateManager.func_179109_b((float)0.117f, (float)-0.74f, (float)0.0f);
                            armorModel.render("rightLegModel", this.getModel.field_178721_j, 0.0625f, 1.0f);
                            GlStateManager.func_179121_F();
                        }
                    } else if (slot == EntityEquipmentSlot.FEET) {
                        if (this.showLeftLeg) {
                            GlStateManager.func_179094_E();
                            this.getModel.field_178722_k.func_78794_c(0.0625f);
                            GlStateManager.func_179109_b((float)-0.117f, (float)-0.74f, (float)0.0f);
                            armorModel.render("leftFootModel", this.getModel.field_178722_k, 0.0625f, 1.0f);
                            GlStateManager.func_179121_F();
                        }
                        if (this.showRightLeg) {
                            GlStateManager.func_179094_E();
                            this.getModel.field_178721_j.func_78794_c(0.0625f);
                            GlStateManager.func_179109_b((float)0.117f, (float)-0.74f, (float)0.0f);
                            armorModel.render("rightFootModel", this.getModel.field_178721_j, 0.0625f, 1.0f);
                            GlStateManager.func_179121_F();
                        }
                    }
                    GL11.glPopMatrix();
                    armorModel.func_178686_a((ModelBase)this.getModel);
                } else if (stack.func_77973_b() instanceof ItemArmor) {
                    this.renderVanilaArmor(n);
                }
            }
        } else if (stack.func_77973_b() instanceof ItemArmor) {
            this.renderVanilaArmor(n);
        }
    }

    private void renderVanilaArmor(int n) {
        if (n == 0) {
            if (this.showHead) {
                this.modelArmorChestplate.field_78116_c.func_78785_a(0.0625f);
                this.modelArmorChestplate.field_178720_f.func_78785_a(0.0625f);
            }
        } else if (n == 1) {
            if (this.showRightArm) {
                this.modelArmorChestplate.field_178723_h.func_78785_a(0.0625f);
            }
            if (this.showLeftArm) {
                this.modelArmorChestplate.field_178724_i.func_78785_a(0.0625f);
            }
            if (this.showBody) {
                this.modelArmorChestplate.field_78115_e.func_78785_a(0.0625f);
            }
        } else if (n == 2 || n == 3) {
            if (n == 2 && this.showBody) {
                this.modelArmor.field_78115_e.func_78785_a(0.0625f);
            }
            if (this.showRightLeg) {
                this.modelArmor.field_178721_j.func_78785_a(0.0625f);
            }
            if (this.showLeftLeg) {
                this.modelArmor.field_178722_k.func_78785_a(0.0625f);
            }
        }
    }

    public void render(PuppetTileEntity puppetTile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        NBTTagCompound tagCompound = puppetTile.serializeNBT();
        this.setNBTTags(tagCompound);
        this.func_147499_a(RenderTilePuppet.getEntityTexture(puppetTile));
        ItemStack headStack = puppetTile.func_70301_a(36);
        ItemStack bodyStack = puppetTile.func_70301_a(37);
        ItemStack legStack = puppetTile.func_70301_a(38);
        ItemStack bootsStack = puppetTile.func_70301_a(39);
        this.getModel = isSkeletonModel ? this.modelSkeleton : this.modelPlayer;
        GL11.glPushMatrix();
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (isRenderModel) {
            this.setBasicSettingsModel();
            GlStateManager.func_179109_b((float)(0.5f + this.puppetPosX), (float)(1.4f + this.puppetPosY), (float)(0.5f + this.puppetPosZ));
            GlStateManager.func_179137_b((double)0.0, (double)0.02, (double)0.0);
            GlStateManager.func_179152_a((float)(0.5f + this.puppetScaleX), (float)(0.5f + this.puppetScaleY), (float)(0.5f + this.puppetScaleZ));
            GlStateManager.func_179139_a((double)1.9, (double)1.9, (double)1.9);
            GlStateManager.func_179114_b((float)this.puppetRotateX, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.puppetRotateY, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.puppetRotateZ, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)tagCompound.func_74760_g("puppetStaticRotateX"), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)tagCompound.func_74760_g("puppetStaticRotateY"), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)tagCompound.func_74760_g("puppetStaticRotateZ"), (float)0.0f, (float)0.0f, (float)1.0f);
            if (this.showHead) {
                if (!headStack.func_190926_b()) {
                    this.getModel.field_78116_c.func_78785_a(0.0625f);
                } else {
                    this.getModel.field_78116_c.func_78785_a(0.0625f);
                    this.getModel.field_178720_f.func_78785_a(0.0625f);
                }
            }
            if (this.showBody) {
                this.getModel.field_78115_e.func_78785_a(0.0625f);
            }
            if (this.showLeftArm) {
                this.getModel.field_178724_i.func_78785_a(0.0625f);
            }
            if (this.showRightArm) {
                this.getModel.field_178723_h.func_78785_a(0.0625f);
            }
            if (this.showLeftLeg) {
                this.getModel.field_178722_k.func_78785_a(0.0625f);
            }
            if (this.showRightLeg) {
                this.getModel.field_178721_j.func_78785_a(0.0625f);
            }
            if (!headStack.func_190926_b()) {
                this.renderArmor(headStack, 0, EntityEquipmentSlot.HEAD);
            }
            if (!bodyStack.func_190926_b()) {
                this.renderArmor(bodyStack, 1, EntityEquipmentSlot.CHEST);
            }
            if (!legStack.func_190926_b()) {
                this.renderArmor(legStack, 2, EntityEquipmentSlot.LEGS);
            }
            if (!bootsStack.func_190926_b()) {
                this.renderArmor(bootsStack, 3, EntityEquipmentSlot.FEET);
            }
        }
        this.renderHeltItem(puppetTile);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public static ResourceLocation getEntityTexture(PuppetTileEntity corpse) {
        NBTTagCompound tagCompound = corpse.serializeNBT();
        if (corpse.currentTexture != null) {
            corpse.currentTexture = new ResourceLocation("taycon", tagCompound.func_74779_i("getSkin"));
            if (tagCompound.func_74767_n("resetSkin")) {
                Minecraft.func_71410_x().func_110434_K().func_110579_a(corpse.currentTexture, (ITextureObject)new CustomBindTextures(tagCompound.func_74779_i("getSkin")));
                tagCompound.func_74757_a("resetSkin", false);
                ModelCitizensRemakeMod.NETWORK.sendToServer(new PacketUpdateNBTTagTileEntity(corpse.func_174877_v().func_177958_n(), corpse.func_174877_v().func_177956_o(), corpse.func_174877_v().func_177952_p(), tagCompound));
            }
            return corpse.currentTexture;
        }
        corpse.currentTexture = new ResourceLocation("taycon", tagCompound.func_74779_i("getSkin"));
        Minecraft.func_71410_x().func_110434_K().func_110579_a(corpse.currentTexture, (ITextureObject)new CustomBindTextures(tagCompound.func_74779_i("getSkin")));
        return corpse.currentTexture;
    }

    private void renderArmor(ItemStack stack, int slot, EntityEquipmentSlot entityEquipmentSlot) {
        this.func_147499_a(this.getArmorResource(null, stack, entityEquipmentSlot, null));
        if (slot == 0) {
            this.renderModelForType(stack, 0, EntityEquipmentSlot.HEAD);
        } else if (slot == 1) {
            this.renderModelForType(stack, 1, EntityEquipmentSlot.CHEST);
        } else if (slot == 2) {
            this.renderModelForType(stack, 3, EntityEquipmentSlot.LEGS);
        } else if (slot == 3) {
            this.renderModelForType(stack, 3, EntityEquipmentSlot.FEET);
        }
    }

    public void renderHeltItem(PuppetTileEntity puppetTile) {
        ItemStack itemStack = puppetTile.func_70301_a(0);
        if (!itemStack.func_190926_b()) {
            if (Loader.isModLoaded((String)"modularwarfare")) {
                if (itemStack.func_77973_b() instanceof ItemGun) {
                    ItemGun itemGun = (ItemGun)itemStack.func_77973_b();
                    GunType gunType = itemGun.type;
                    GL11.glPushMatrix();
                    if (gunType.animationType == WeaponAnimationType.BASIC) {
                        this.getModel.field_178723_h.func_78794_c(0.0625f);
                        GlStateManager.func_179137_b((double)-0.06, (double)0.38, (double)-0.02);
                        GL11.glScalef((float)this.itemScaleX, (float)this.itemScaleY, (float)this.itemScaleZ);
                        GL11.glTranslatef((float)this.itemPosX, (float)this.itemPosY, (float)this.itemPosZ);
                        GL11.glRotatef((float)this.itemRotateY, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)this.itemRotateZ, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)this.itemRotateX, (float)1.0f, (float)0.0f, (float)0.0f);
                        if (ClientRenderHooks.customRenderers[gunType.id] != null) {
                            ClientRenderHooks.customRenderers[gunType.id].renderItem(CustomItemRenderType.RENDER_TILE, null, itemStack, new Object[]{puppetTile.func_145831_w()});
                        }
                    }
                    GL11.glPopMatrix();
                } else {
                    this.renderItem(puppetTile, false, itemStack);
                }
            } else {
                this.renderItem(puppetTile, false, itemStack);
            }
        }
    }

    public void renderItem(PuppetTileEntity puppetTile, boolean isLeftArm, ItemStack stack) {
        GL11.glPushMatrix();
        if (isRenderModel && isBipedArm && this.showRightArm) {
            if (isLeftArm) {
                this.getModel.field_178724_i.func_78794_c(0.0625f);
            } else {
                this.getModel.field_178723_h.func_78794_c(0.0625f);
            }
        }
        float x = -0.0625f;
        if (isSkeletonModel) {
            x = -0.0225f;
        }
        GL11.glTranslatef((float)x, (float)0.4375f, (float)0.0925f);
        GL11.glScalef((float)this.itemScaleX, (float)this.itemScaleY, (float)this.itemScaleZ);
        GL11.glTranslatef((float)this.itemPosX, (float)this.itemPosY, (float)this.itemPosZ);
        GL11.glRotatef((float)this.itemRotateY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.itemRotateZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)this.itemRotateX, (float)1.0f, (float)0.0f, (float)0.0f);
        if (!isRenderModel) {
            GlStateManager.func_179114_b((float)puppetTile.serializeNBT().func_74760_g("puppetStaticRotateX"), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)puppetTile.serializeNBT().func_74760_g("puppetStaticRotateY"), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)puppetTile.serializeNBT().func_74760_g("puppetStaticRotateZ"), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)0.02f, (float)0.15f, (float)-0.215f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)-78.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (!stack.func_190926_b()) {
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        }
        GL11.glPopMatrix();
    }

    private boolean isLegSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.LEGS;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, String type) {
        ItemArmor item = (ItemArmor)stack.func_77973_b();
        String texture = item.func_82812_d().func_179242_c();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.isLegSlot(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EntityEquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public void setNBTTags(NBTTagCompound tagCompound) {
        this.puppetPosX = tagCompound.func_74760_g("puppetPosX");
        this.puppetPosY = tagCompound.func_74760_g("puppetPosY");
        this.puppetPosZ = tagCompound.func_74760_g("puppetPosZ");
        this.puppetScaleX = tagCompound.func_74760_g("puppetScaleX");
        this.puppetScaleY = tagCompound.func_74760_g("puppetScaleY");
        this.puppetScaleZ = tagCompound.func_74760_g("puppetScaleZ");
        this.puppetRotateX = tagCompound.func_74760_g("puppetRotateX");
        this.puppetRotateY = tagCompound.func_74760_g("puppetRotateY");
        this.puppetRotateZ = tagCompound.func_74760_g("puppetRotateZ");
        isBipedArm = tagCompound.func_74767_n("isBipedArm");
        isRenderModel = tagCompound.func_74767_n("isRenderModel");
        isSkeletonModel = tagCompound.func_74767_n("isSkeleton");
        this.showHead = tagCompound.func_74767_n("showHead");
        this.showBody = tagCompound.func_74767_n("showBody");
        this.showLeftArm = tagCompound.func_74767_n("showLeftArm");
        this.showRightArm = tagCompound.func_74767_n("showRightArm");
        this.showLeftLeg = tagCompound.func_74767_n("showLeftLeg");
        this.showRightLeg = tagCompound.func_74767_n("showRightLeg");
        this.headScaleX = tagCompound.func_74760_g("headScaleX");
        this.headScaleY = tagCompound.func_74760_g("headScaleY");
        this.headScaleZ = tagCompound.func_74760_g("headScaleZ");
        this.headRotateX = tagCompound.func_74760_g("headRotateX");
        this.headRotateY = tagCompound.func_74760_g("headRotateY");
        this.headRotateZ = tagCompound.func_74760_g("headRotateZ");
        this.bodyScaleX = tagCompound.func_74760_g("bodyScaleX");
        this.bodyScaleY = tagCompound.func_74760_g("bodyScaleY");
        this.bodyScaleZ = tagCompound.func_74760_g("bodyScaleZ");
        this.bodyRotateX = tagCompound.func_74760_g("bodyRotateX");
        this.bodyRotateY = tagCompound.func_74760_g("bodyRotateY");
        this.bodyRotateZ = tagCompound.func_74760_g("bodyRotateZ");
        this.leftArmScaleX = tagCompound.func_74760_g("leftArmScaleX");
        this.leftArmScaleY = tagCompound.func_74760_g("leftArmScaleY");
        this.leftArmScaleZ = tagCompound.func_74760_g("leftArmScaleZ");
        this.leftArmRotateX = tagCompound.func_74760_g("leftArmRotateX");
        this.leftArmRotateY = tagCompound.func_74760_g("leftArmRotateY");
        this.leftArmRotateZ = tagCompound.func_74760_g("leftArmRotateZ");
        this.rightArmScaleX = tagCompound.func_74760_g("rightArmScaleX");
        this.rightArmScaleY = tagCompound.func_74760_g("rightArmScaleY");
        this.rightArmScaleZ = tagCompound.func_74760_g("rightArmScaleZ");
        this.rightArmRotateX = tagCompound.func_74760_g("rightArmRotateX");
        this.rightArmRotateY = tagCompound.func_74760_g("rightArmRotateY");
        this.rightArmRotateZ = tagCompound.func_74760_g("rightArmRotateZ");
        this.rightLegScaleX = tagCompound.func_74760_g("rightLegScaleX");
        this.rightLegScaleY = tagCompound.func_74760_g("rightLegScaleY");
        this.rightLegScaleZ = tagCompound.func_74760_g("rightLegScaleZ");
        this.rightLegRotateX = tagCompound.func_74760_g("rightLegRotateX");
        this.rightLegRotateY = tagCompound.func_74760_g("rightLegRotateY");
        this.rightLegRotateZ = tagCompound.func_74760_g("rightLegRotateZ");
        this.leftLegScaleX = tagCompound.func_74760_g("leftLegScaleX");
        this.leftLegScaleY = tagCompound.func_74760_g("leftLegScaleY");
        this.leftLegScaleZ = tagCompound.func_74760_g("leftLegScaleZ");
        this.leftLegRotateX = tagCompound.func_74760_g("leftLegRotateX");
        this.leftLegRotateY = tagCompound.func_74760_g("leftLegRotateY");
        this.leftLegRotateZ = tagCompound.func_74760_g("leftLegRotateZ");
        this.itemScaleX = tagCompound.func_74760_g("itemScaleX");
        this.itemScaleY = tagCompound.func_74760_g("itemScaleY");
        this.itemScaleZ = tagCompound.func_74760_g("itemScaleZ");
        this.itemPosX = tagCompound.func_74760_g("itemPosX");
        this.itemPosY = tagCompound.func_74760_g("itemPosY");
        this.itemPosZ = tagCompound.func_74760_g("itemPosZ");
        this.itemRotateX = tagCompound.func_74760_g("itemRotateX");
        this.itemRotateY = tagCompound.func_74760_g("itemRotateY");
        this.itemRotateZ = tagCompound.func_74760_g("itemRotateZ");
    }

    public void setBasicSettingsModel() {
        this.getModel.field_78116_c.field_78795_f = this.headRotateX;
        this.getModel.field_78116_c.field_78796_g = this.headRotateY;
        this.getModel.field_78116_c.field_78808_h = this.headRotateZ;
        this.getModel.field_178720_f.field_78795_f = this.headRotateX;
        this.getModel.field_178720_f.field_78796_g = this.headRotateY;
        this.getModel.field_178720_f.field_78808_h = this.headRotateZ;
        this.getModel.field_178724_i.field_78795_f = this.leftArmRotateX;
        this.getModel.field_178724_i.field_78796_g = this.leftArmRotateY;
        this.getModel.field_178724_i.field_78808_h = this.leftArmRotateZ;
        this.getModel.field_178723_h.field_78795_f = this.rightArmRotateX;
        this.getModel.field_178723_h.field_78796_g = this.rightArmRotateY;
        this.getModel.field_178723_h.field_78808_h = this.rightArmRotateZ;
        this.getModel.field_178721_j.field_78795_f = this.rightLegRotateX;
        this.getModel.field_178721_j.field_78796_g = this.rightLegRotateY;
        this.getModel.field_178721_j.field_78808_h = this.rightLegRotateZ;
        this.getModel.field_178722_k.field_78795_f = this.leftLegRotateX;
        this.getModel.field_178722_k.field_78796_g = this.leftLegRotateY;
        this.getModel.field_178722_k.field_78808_h = this.leftLegRotateZ;
        this.modelArmorChestplate.field_78116_c.field_78795_f = this.headRotateX;
        this.modelArmorChestplate.field_78116_c.field_78796_g = this.headRotateY;
        this.modelArmorChestplate.field_78116_c.field_78808_h = this.headRotateZ;
        this.modelArmorChestplate.field_178720_f.field_78795_f = this.headRotateX;
        this.modelArmorChestplate.field_178720_f.field_78796_g = this.headRotateY;
        this.modelArmorChestplate.field_178720_f.field_78808_h = this.headRotateZ;
        this.modelArmorChestplate.field_178724_i.field_78795_f = this.leftArmRotateX;
        this.modelArmorChestplate.field_178724_i.field_78796_g = this.leftArmRotateY;
        this.modelArmorChestplate.field_178724_i.field_78808_h = this.leftArmRotateZ;
        this.modelArmorChestplate.field_178723_h.field_78795_f = this.rightArmRotateX;
        this.modelArmorChestplate.field_178723_h.field_78796_g = this.rightArmRotateY;
        this.modelArmorChestplate.field_178723_h.field_78808_h = this.rightArmRotateZ;
        this.modelArmor.field_178721_j.field_78795_f = this.rightLegRotateX;
        this.modelArmor.field_178721_j.field_78796_g = this.rightLegRotateY;
        this.modelArmor.field_178721_j.field_78808_h = this.rightLegRotateZ;
        this.modelArmor.field_178722_k.field_78795_f = this.leftLegRotateX;
        this.modelArmor.field_178722_k.field_78796_g = this.leftLegRotateY;
        this.modelArmor.field_178722_k.field_78808_h = this.leftLegRotateZ;
    }

    static {
        textureListField = null;
        ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    }
}

