/*
 * Decompiled with CFR 0.152.
 */
package com.medelcitizens.common.network;

import com.medelcitizens.ModelCitizensRemakeMod;
import com.medelcitizens.common.network.PacketBase;
import com.medelcitizens.common.network.PacketUpdateNBTTagTileEntity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ChannelHandler.Sharable
public class NetworkHandler
extends MessageToMessageCodec<FMLProxyPacket, PacketBase> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private LinkedList<Class<? extends PacketBase>> packets = new LinkedList();
    private boolean modInitialised = false;
    private ConcurrentLinkedQueue<PacketBase> receivedPacketsClient = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<String, ConcurrentLinkedQueue<PacketBase>> receivedPacketsServer = new ConcurrentHashMap();

    public boolean registerPacket(Class<? extends PacketBase> cl) {
        if (this.packets.size() > 256) {
            ModelCitizensRemakeMod.LOGGER.warn("Packet limit exceeded in Tycoon Mod packet handler by packet " + cl.getCanonicalName() + ".");
            return false;
        }
        if (this.packets.contains(cl)) {
            ModelCitizensRemakeMod.LOGGER.warn("Tried to register " + cl.getCanonicalName() + " packet class twice.");
            return false;
        }
        if (this.modInitialised) {
            ModelCitizensRemakeMod.LOGGER.warn("Tried to register packet " + cl.getCanonicalName() + " after mod initialisation.");
            return false;
        }
        this.packets.add(cl);
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, PacketBase msg, List<Object> out) throws Exception {
        try {
            ByteBuf encodedData = Unpooled.buffer();
            Class<?> cl = msg.getClass();
            if (!this.packets.contains(cl)) {
                throw new NullPointerException("Packet not registered : " + cl.getCanonicalName());
            }
            byte discriminator = (byte)this.packets.indexOf(cl);
            encodedData.writeByte((int)discriminator);
            msg.encodeInto(ctx, encodedData);
            FMLProxyPacket proxyPacket = new FMLProxyPacket(new PacketBuffer(encodedData.copy()), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
            out.add(proxyPacket);
        }
        catch (Exception e) {
            ModelCitizensRemakeMod.LOGGER.error("ERROR encoding packet");
            ModelCitizensRemakeMod.LOGGER.throwing((Throwable)e);
        }
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        try {
            ByteBuf encodedData = msg.payload();
            byte discriminator = encodedData.readByte();
            Class<? extends PacketBase> cl = this.packets.get(discriminator);
            if (cl == null) {
                throw new NullPointerException("Packet not registered for discriminator : " + discriminator);
            }
            PacketBase packet = cl.newInstance();
            packet.decodeInto(ctx, encodedData.slice());
            switch (FMLCommonHandler.instance().getEffectiveSide()) {
                case CLIENT: {
                    this.receivedPacketsClient.offer(packet);
                    break;
                }
                case SERVER: {
                    INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                    EntityPlayerMP player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                    if (!this.receivedPacketsServer.containsKey(player.func_70005_c_())) {
                        this.receivedPacketsServer.put(player.func_70005_c_(), new ConcurrentLinkedQueue());
                    }
                    this.receivedPacketsServer.get(player.func_70005_c_()).offer(packet);
                    break;
                }
            }
        }
        catch (Exception e) {
            ModelCitizensRemakeMod.LOGGER.error("ERROR decoding packet");
            ModelCitizensRemakeMod.LOGGER.throwing((Throwable)e);
        }
    }

    public void handleClientPackets() {
        PacketBase packet = this.receivedPacketsClient.poll();
        while (packet != null) {
            packet.handleClientSide(this.getClientPlayer());
            packet = this.receivedPacketsClient.poll();
        }
    }

    public void handleServerPackets() {
        for (String playerName : this.receivedPacketsServer.keySet()) {
            ConcurrentLinkedQueue<PacketBase> receivedPacketsFromPlayer = this.receivedPacketsServer.get(playerName);
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
            if (player == null) {
                receivedPacketsFromPlayer.clear();
                continue;
            }
            PacketBase packet = receivedPacketsFromPlayer.poll();
            while (packet != null) {
                packet.handleServerSide(player);
                packet = receivedPacketsFromPlayer.poll();
            }
        }
    }

    public void initialise() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("TycoonMod", new ChannelHandler[]{this});
        this.registerPacket(PacketUpdateNBTTagTileEntity.class);
    }

    public void postInitialise() {
        if (this.modInitialised) {
            return;
        }
        this.modInitialised = true;
        Collections.sort(this.packets, new Comparator<Class<? extends PacketBase>>(){

            @Override
            public int compare(Class<? extends PacketBase> c1, Class<? extends PacketBase> c2) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(c1.getCanonicalName(), c2.getCanonicalName());
                if (com == 0) {
                    com = c1.getCanonicalName().compareTo(c2.getCanonicalName());
                }
                return com;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(PacketBase packet) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendTo(PacketBase packet, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToDimension(PacketBase packet, int dimensionID) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionID);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToServer(PacketBase packet) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    public void sendToAllTracking(PacketBase packet, Entity entity) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TRACKING_ENTITY);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entity);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAll(Packet packet) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a(packet);
    }

    public void sendTo(Packet packet, EntityPlayerMP player) {
        player.field_71135_a.func_147359_a(packet);
    }

    public void sendToAllAround(Packet packet, NetworkRegistry.TargetPoint point) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148543_a(null, point.x, point.y, point.z, point.range, point.dimension, packet);
    }

    public void sendToDimension(Packet packet, int dimensionID) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148537_a(packet, dimensionID);
    }

    public void sendToServer(Packet packet) {
        Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a(packet);
    }

    public void sendToAllAround(PacketBase packet, double x, double y, double z, float range, int dimension) {
        this.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dimension, x, y, z, (double)range));
    }
}

