/*
 * Decompiled with CFR 0.152.
 */
package com.medelcitizens.common.network;

import com.medelcitizens.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketUpdateNBTTagTileEntity
extends PacketBase {
    private int x;
    private int y;
    private int z;
    private NBTTagCompound tagCompound;

    public PacketUpdateNBTTagTileEntity() {
    }

    public PacketUpdateNBTTagTileEntity(int x, int y, int z, NBTTagCompound tagCompound) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.tagCompound = tagCompound;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.x);
        data.writeInt(this.y);
        data.writeInt(this.z);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)this.tagCompound);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.tagCompound = ByteBufUtils.readTag((ByteBuf)data);
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        World world = player.func_130014_f_();
        TileEntity tileEntity = world.func_175625_s(new BlockPos(this.x, this.y, this.z));
        if (tileEntity != null) {
            tileEntity.deserializeNBT(this.tagCompound);
            tileEntity.func_70296_d();
            world.func_184138_a(tileEntity.func_174877_v(), world.func_180495_p(tileEntity.func_174877_v()), world.func_180495_p(tileEntity.func_174877_v()), 3);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }
}

