/*
 * Decompiled with CFR 0.152.
 */
package com.medelcitizens.common.utillity;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public static void renderText(String text, int givenX, int givenY, int color) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(text, givenX, givenY, color);
        GL11.glPopMatrix();
    }

    public static void renderTextWithShadow(String text, int givenX, int givenY, int color) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_175063_a(text, (float)givenX, (float)givenY, color);
        GL11.glPopMatrix();
    }

    public static void renderCenteredText(String text, int givenX, int givenY, int color) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.renderText(text, givenX - mc.field_71466_p.func_78256_a(text) / 2, givenY, color);
        GL11.glPopMatrix();
    }

    public static void renderTextScaled(String text, int givenX, int givenY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiUtils.renderText(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaled(String text, int givenX, int givenY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiUtils.renderCenteredText(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaledWithOutline(String text, int givenX, int givenY, int color, int givenOutlineColor, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiUtils.renderCenteredTextWithOutline(text, 0, 0, color, givenOutlineColor);
        GL11.glPopMatrix();
    }

    public static void renderTextWithOutline(String text, int x, int y, int color, int outlineColor) {
        GuiUtils.renderText(text, x - 1, y + 1, outlineColor);
        GuiUtils.renderText(text, x, y + 1, outlineColor);
        GuiUtils.renderText(text, x + 1, y + 1, outlineColor);
        GuiUtils.renderText(text, x - 1, y, outlineColor);
        GuiUtils.renderText(text, x + 1, y, outlineColor);
        GuiUtils.renderText(text, x - 1, y - 1, outlineColor);
        GuiUtils.renderText(text, x, y - 1, outlineColor);
        GuiUtils.renderText(text, x + 1, y - 1, outlineColor);
        GuiUtils.renderText(text, x, y, color);
    }

    public static void renderTextScaledWithOutline(String text, int x, int y, int color, int outlineColor, double givenScale) {
        GuiUtils.renderTextScaled(text, x - 1, y + 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x, y + 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x + 1, y + 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x - 1, y, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x + 1, y, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x - 1, y - 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x, y - 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x + 1, y - 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x, y, color, givenScale);
    }

    public static void renderCenteredTextWithOutline(String text, int x, int y, int color, int outlineColor) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        GuiUtils.renderText(text, x - 1 - fr.func_78256_a(text) / 2, y + 1, outlineColor);
        GuiUtils.renderText(text, x - fr.func_78256_a(text) / 2, y + 1, outlineColor);
        GuiUtils.renderText(text, x + 1 - fr.func_78256_a(text) / 2, y + 1, outlineColor);
        GuiUtils.renderText(text, x - 1 - fr.func_78256_a(text) / 2, y, outlineColor);
        GuiUtils.renderText(text, x + 1 - fr.func_78256_a(text) / 2, y, outlineColor);
        GuiUtils.renderText(text, x - 1 - fr.func_78256_a(text) / 2, y - 1, outlineColor);
        GuiUtils.renderText(text, x - fr.func_78256_a(text) / 2, y - 1, outlineColor);
        GuiUtils.renderText(text, x + 1 - fr.func_78256_a(text) / 2, y - 1, outlineColor);
        GuiUtils.renderText(text, x - fr.func_78256_a(text) / 2, y, color);
    }

    public static void renderRect(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor) {
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        if (givenX < givenWidth) {
            int i = givenX;
            givenX = givenWidth;
            givenWidth = i;
        }
        if (givenY < givenHeight) {
            int j = givenY;
            givenY = givenHeight;
            givenHeight = j;
        }
        float f3 = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
    }

    public static void renderRect(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor, float givenAlpha) {
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        if (givenX < givenWidth) {
            int i = givenX;
            givenX = givenWidth;
            givenWidth = i;
        }
        if (givenY < givenHeight) {
            int j = givenY;
            givenY = givenHeight;
            givenHeight = j;
        }
        float f3 = givenAlpha;
        float f = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderRectWithFade(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor, float givenFade) {
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        if (givenX < givenWidth) {
            int i = givenX;
            givenX = givenWidth;
            givenWidth = i;
        }
        if (givenY < givenHeight) {
            int j = givenY;
            givenY = givenHeight;
            givenHeight = j;
        }
        float f3 = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)givenFade);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderRectWithOutline(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor, int givenOutlineColor, int outlineThickness) {
        GuiUtils.renderRect(givenX - outlineThickness, givenY - outlineThickness, givenWidth + outlineThickness * 2, givenHeight + outlineThickness * 2, givenOutlineColor);
        GuiUtils.renderRect(givenX, givenY, givenWidth, givenHeight, givenColor);
    }

    public static void renderOutline(int givenX, int givenY, int givenWidth, int givenHeight, int givenOutlineColor, int outlineThickness) {
        GuiUtils.renderRect(givenX - outlineThickness, givenY - outlineThickness, givenWidth + outlineThickness * 2, outlineThickness, givenOutlineColor);
        GuiUtils.renderRect(givenX - outlineThickness + 1, givenY + givenHeight - outlineThickness + 1, givenWidth + outlineThickness * 2 - 2, outlineThickness, givenOutlineColor);
        GuiUtils.renderRect(givenX - outlineThickness, givenY - outlineThickness + 1, outlineThickness, givenHeight + outlineThickness * 2 - 1, givenOutlineColor);
        GuiUtils.renderRect(givenX + givenWidth + outlineThickness - 1, givenY - outlineThickness + 1, outlineThickness, givenHeight + outlineThickness * 2 - 1, givenOutlineColor);
    }

    public static void renderRectWithGradient(int givenX, int givenY, int givenWidth, int givenHeight, int startColor, int endColor, double givenZLevel) {
        GlStateManager.func_179094_E();
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, givenZLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, givenZLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void renderRectWithGradientWithAlpha(int givenX, int givenY, int givenWidth, int givenHeight, int startColor, int endColor, double givenZLevel, float givenAlphaStart, float givenAlphaEnd) {
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, givenZLevel).func_181666_a(f1, f2, f3, givenAlphaStart).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, givenZLevel).func_181666_a(f1, f2, f3, givenAlphaStart).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, givenAlphaEnd).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, givenAlphaEnd).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void renderPositionedImageNoDepth(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        GL11.glPushMatrix();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GuiUtils.renderPositionedImage(par1, par2, par3, par4, par5, width, height);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GL11.glPopMatrix();
    }

    public static void renderPositionedImage(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiUtils.renderImage(-width / 2.0f, -height / 2.0f, par1, width, height);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderPositionedTextScaled(String givenText, double par2, double par3, double par4, float par5, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiUtils.renderCenteredTextScaled(givenText, 0, 0, givenColor, par5);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderImage(double x, double y, ResourceLocation image, double width, double height) {
        GuiUtils.renderColor(0xFFFFFF);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void renderImageTransparent(double x, double y, ResourceLocation image, double width, double height, double alpha) {
        GuiUtils.renderColor(0xFFFFFF, alpha);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void renderImageCentered(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight) {
        GL11.glPushMatrix();
        GuiUtils.renderImage(givenX - givenWidth / 2.0, givenY - givenHeight / 2.0, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    public static void renderImageCenteredTransparent(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight, double alpha) {
        GlStateManager.func_179094_E();
        GuiUtils.renderImageTransparent(givenX - givenWidth / 2.0, givenY - givenHeight / 2.0, givenTexture, givenWidth, givenHeight, alpha);
        GlStateManager.func_179121_F();
    }

    public static void renderImageCenteredScaled(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight, float givenScale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(givenX - givenX * (double)givenScale), (double)(givenY - givenY * (double)givenScale), (double)0.0);
        GlStateManager.func_179152_a((float)givenScale, (float)givenScale, (float)givenScale);
        GuiUtils.renderImageCentered(givenX, givenY, givenTexture, givenWidth, givenHeight);
        GlStateManager.func_179121_F();
    }

    public static void renderImageTransparent(int givenX, int givenY, ResourceLocation givenTexture, int givenWidth, int givenHeight, double givenAlpha) {
        GL11.glPushMatrix();
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)givenAlpha);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GuiUtils.renderImage(givenX, givenY, givenTexture, givenWidth, givenHeight);
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)255.0);
        GL11.glPopMatrix();
    }

    public static String getScoreboardTitle(Minecraft mc) {
        if (mc.field_71441_e != null && mc.field_71441_e.func_96441_U() != null) {
            ScoreObjective scoreobjective = mc.field_71441_e.func_96441_U().func_96539_a(1);
            if (scoreobjective != null) {
                String scoreTitle = scoreobjective.func_96678_d().replace("\u00a7", "").replaceAll("[a-z]", "").replaceAll("[0-9]", "");
                return scoreTitle;
            }
        } else {
            return null;
        }
        return null;
    }

    public static void renderColor(int par1) {
        Color color = Color.decode("" + par1);
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }

    public static void renderColor(int par1, double alpha) {
        Color color = Color.decode("" + par1);
        double red = (double)color.getRed() / 255.0;
        double green = (double)color.getGreen() / 255.0;
        double blue = (double)color.getBlue() / 255.0;
        GL11.glColor4d((double)red, (double)green, (double)blue, (double)alpha);
    }

    public static void renderCenteredTextWithShadow(String text, int x, int y, int color, int outlineColor) {
        GlStateManager.func_179094_E();
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        GuiUtils.renderTextWithShadow(text, x - fr.func_78256_a(text) / 2, y, color);
        GlStateManager.func_179121_F();
    }

    public static boolean isInBox(int x, int y, int width, int height, int checkX, int checkY) {
        return checkX >= x && checkY >= y && checkX <= x + width && checkY <= y + height;
    }

    public static void renderBoundingBox(AxisAlignedBB givenBB) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderBoundingBoxFilled(AxisAlignedBB givenBB) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static double getDistanceToClientCamera(double x, double y, double z) {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        double d3 = renderManager.field_78730_l - x;
        double d4 = renderManager.field_78731_m - y;
        double d5 = renderManager.field_78728_n - z;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public static BufferedImage downloadBanner(String url) {
        try {
            return ImageIO.read(new URL(url));
        }
        catch (IOException e) {
            System.out.println("Errors reading online image: '" + url + "'");
            return null;
        }
    }
}

