/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.mixin.trails.entity;

import it.hurts.octostudios.perception.common.modules.trail.config.data.TrailConfigData;
import it.hurts.octostudios.perception.common.modules.trail.misc.ITrailConfigProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements ITrailConfigProvider {
    @Unique
    private TrailConfigData perception$trailData = new TrailConfigData();

    @Override
    public TrailConfigData getTrailConfigData() {
        return this.perception$trailData;
    }

    @Override
    public void setTrailConfigData(TrailConfigData data) {
        this.perception$trailData = data;
    }

    public int getTrailMaxLength() {
        return this.getTrailConfigData().getMaxPoints();
    }

    public int getTrailUpdateFrequency() {
        return this.getTrailConfigData().getUpdateFrequency();
    }

    public double getTrailScale() {
        return this.getTrailConfigData().getSize();
    }

    public Vec3 getTrailPosition(float partialTicks) {
        Entity entity = (Entity)this;
        TrailConfigData data = this.getTrailConfigData();
        Vector3f offset = data.getPositionOffset();
        Vec3 entityPosition = (entity.tickCount > 1 ? entity.getPosition(partialTicks) : entity.position()).add(entity.getDeltaMovement().normalize().scale((double)(-data.getMotionShift()))).add((double)offset.x(), (double)offset.y(), (double)offset.z());
        Player player = entity.getCommandSenderWorld().getNearestPlayer(entity, this.getTrailRenderDistance());
        if (player == null) {
            return entityPosition;
        }
        Vec3 playerPosition = player.getEyePosition(partialTicks);
        entityPosition = entityPosition.add(entityPosition.subtract(playerPosition).normalize().scale((double)data.getBackwardShift()));
        return entityPosition;
    }

    public boolean isTrailGrowing() {
        Entity entity = (Entity)this;
        return entity.getKnownMovement().length() >= (double)this.getTrailConfigData().getMinSpeed();
    }

    public boolean isTrailAlive() {
        Entity entity = (Entity)this;
        return entity.isAlive();
    }

    public int getTrailFadeInColor() {
        return (int)Long.parseLong(this.getTrailConfigData().getFadeInColor().replace("#", ""), 16);
    }

    public int getTrailFadeOutColor() {
        return (int)Long.parseLong(this.getTrailConfigData().getFadeOutColor().replace("#", ""), 16);
    }
}

