/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.mixin.trails.entity;

import it.hurts.octostudios.perception.common.mixin.trails.entity.EntityMixin;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.component.FireworkExplosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FireworkRocketEntity.class})
public abstract class FireworkRocketEntityMixin
extends EntityMixin {
    @Shadow
    protected abstract List<FireworkExplosion> getExplosions();

    @Override
    public int getTrailFadeInColor() {
        FireworkRocketEntity entity = (FireworkRocketEntity)this;
        List<FireworkExplosion> explosions = this.getExplosions();
        int maxSize = explosions.size();
        if (maxSize == 0) {
            return -1;
        }
        ArrayList colors = new ArrayList();
        for (FireworkExplosion explosion : explosions) {
            colors.addAll(explosion.colors());
        }
        int count = colors.size();
        if (count < 2) {
            return colors.isEmpty() ? -1 : (Integer)colors.getFirst() & 0xFFFFFF | 0xFF000000;
        }
        int totalTime = count * 3;
        int tick = entity.tickCount % totalTime;
        float t = (float)tick / (float)totalTime * (float)colors.size();
        int index = (int)Math.floor(t) % colors.size();
        float fraction = t - (float)((int)t);
        Integer color1 = (Integer)colors.get(index);
        Integer color2 = (Integer)colors.get((index + 1) % colors.size());
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * fraction);
        int g = (int)((float)g1 + (float)(g2 - g1) * fraction);
        int b = (int)((float)b1 + (float)(b2 - b1) * fraction);
        return r << 16 | g << 8 | b | 0xFF000000;
    }
}

