/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.modules.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.hurts.octostudios.octolib.modules.config.ConfigManager;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class OctolibCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"octolib").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"config").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").then(Commands.literal((String)"all").executes(conComponent -> {
            int counter = 0;
            boolean isAdmin = ((CommandSourceStack)conComponent.getSource()).hasPermission(4);
            for (String path : ConfigManager.getAllPaths()) {
                try {
                    if (ConfigManager.isServerConfig(path)) {
                        if (isAdmin) {
                            ConfigManager.reload(path);
                            ConfigManager.syncConfig(path, ((CommandSourceStack)conComponent.getSource()).getServer());
                        } else {
                            ((CommandSourceStack)conComponent.getSource()).sendFailure((Component)Component.literal((String)"You have not permission to reload config."));
                        }
                    } else {
                        ConfigManager.reload(path);
                    }
                    ++counter;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    ((CommandSourceStack)conComponent.getSource()).sendFailure((Component)Component.literal((String)"Error occurs while reload config by path ").append((Component)Component.literal((String)("\"" + path + "\""))));
                    return 0;
                }
            }
            ((CommandSourceStack)conComponent.getSource()).sendSystemMessage((Component)Component.literal((String)(counter + " configs reload successfully")));
            return 1;
        }))).then(Commands.argument((String)"path", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.suggest(ConfigManager.getAllPaths(), (SuggestionsBuilder)b)).executes(c -> {
            String path = StringArgumentType.getString((CommandContext)c, (String)"path");
            boolean isAdmin = ((CommandSourceStack)c.getSource()).hasPermission(4);
            if (!ConfigManager.getAllPaths().contains(path)) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Config by path \"" + path + "\" does not exist")));
                return 0;
            }
            try {
                if (ConfigManager.isServerConfig(path)) {
                    if (isAdmin) {
                        ConfigManager.reload(path);
                        ConfigManager.syncConfig(path, ((CommandSourceStack)c.getSource()).getServer());
                    } else {
                        ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"You have not permission to reload config."));
                    }
                } else {
                    ConfigManager.reload(path);
                }
                ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)Component.literal((String)("Config with path \"" + path + "\" has been reloaded successfully")));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Error occurs while reloading config by path ").append((Component)Component.literal((String)("\"" + path + "\""))));
                return 0;
            }
            return 1;
        })))));
    }
}

